using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace karte3
{
    class Program
    {
        static int brojKarata, brojUpita;
        static int[] karte;
        static int prekidi = 0;

        static bool DaLiJePrekid(int i)
        {
            return i >= 1 && i < brojKarata && karte[i - 1] > karte[i];
        }

        static void InicijalizujPrekide()
        {
            prekidi = 0;
            for (int i = 1; i < brojKarata; i++)
                if (karte[i - 1] > karte[i])
                    prekidi++;
        }

        static void ObradiZamenu(int i, int j)
        {
            var promenjeni = new HashSet<int> { i - 1, i, j - 1, j };
            foreach (var indeks in promenjeni)
                if (DaLiJePrekid(indeks))
                    prekidi--;

            (karte[i], karte[j]) = (karte[j], karte[i]);

            foreach (var indeks in promenjeni)
                if (DaLiJePrekid(indeks))
                    prekidi++;
        }

        static void Main()
        {
            var ulaz = Console.ReadLine().Split();
            brojKarata = int.Parse(ulaz[0]);
            brojUpita = int.Parse(ulaz[1]);
            karte = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);

            InicijalizujPrekide();
            Console.WriteLine(prekidi);

            for (int q = 0; q < brojUpita; q++)
            {
                var zamena = Console.ReadLine().Split();
                int i = int.Parse(zamena[0]) - 1;
                int j = int.Parse(zamena[1]) - 1;
                ObradiZamenu(i, j);
                Console.WriteLine(prekidi);
            }
        }
    }

}